function P81_v
% Problem 8.1 :	Nonlinear parametric pendulum
% Part v. Sensitive dependence on initial conditions

% Define some constants
omega0=1;       % Natural frequency of the pendulum
gamma=0.1;      % Damping coefficient
h=[1.80 2.20];         % Two amplitudes of forcing 

% Define some parameters for using Runge-Kutta metod
tspan=[0 500];      % Time span to be obtained
theta0=[1e-1,0];    % Initial conditions

% Choose time step smaller than 0.01 sec
optn=odeset('InitialStep',1e-2,'MaxStep',1e-2);

% Simulation with h=1.8
[T1,Y1]=ode45(@(t,x) Npp(t,x,gamma,omega0,h(1)),tspan,theta0,optn);
% Simulation with h=2.2
[T2,Y2]=ode45(@(t,x) Npp(t,x,gamma,omega0,h(2)),tspan,theta0,optn);
% Generate figure
figure(1); 
% Plot steady state response for given h
plot(T1,Y1(:,1),'r-',T2,Y2(:,1),'b--');
grid on; axis tight;
xlabel('\bfTime (second)');
ylabel('\bfAngular Position \theta (rad)');
title('\bfResponse (t,\theta) with different h');
legend(['\bfh=' num2str(h(1))],['\bfh=' num2str(h(2))], ...
    'Location','NorthWest');
end

function dx=Npp(t,x,gamma,omega0,h)
% Describe nonlinear parametric pendulum motion
dx(1,1)=x(2);
dx(2,1)=-2*gamma*x(2)-omega0^2*(1+h*cos(2*omega0*t))*sin(x(1));
end